
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Feb 07 09:42:53 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MW_ATP_UTIL_sep.c#1:csrc:1
   *  \author arield
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/*lint --e(553) */
/*lint --e(713) */
/************* Include Files **************************************/
//#include "CRYS.h"
#include "MW_ATP_defines.h"
#include "DX_VOS_Mem.h"
#include "DX_VOS_File.h"
/************************ Defines **********************************/
/************************ Enums ************************************/
/************************ Typedefs *********************************/
/************************ Global Data ******************************/

/************************ Public Functions *************************/
/********************************************************************************
 * Function Name:                                                           
 * 	MW_ATP_UTIL_CC_LoadCode 		
 * 
 * Inputs:
 * 	DxUint32_t  TST_resAdd - resident address
 *  DxUint32_t  TST_cacheAddr - cache address
 *
 * Outputs:
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function load the resident and cache. The implementation of this function 
 * is done for ARM integration board hardware and provided as an example and 
 * reference only. 
 * 
 ********************************************************************************/
DxError_t MW_ATP_UTIL_CC_LoadCode(DxUint32_t TST_resAdd, DxUint32_t TST_cacheAddr)
{
  /* reg val */
  DxUint32_t    readBytes;
  DxUint32_t    size;

  /* files descriptors */
  DxVosFile TST_Resident_file;
  DxVosFile TST_cache_file;

  /*---------------------
      CODE
  -------------------------*/
  TST_ATP_Error  = TST_PASS;

  TST_ATP_Error = DX_VOS_FOpen(&TST_Resident_file, "resident.image.bin" ,"rb");
  if ((TST_ATP_Error != DX_SUCCESS)||(TST_Resident_file == DX_NULL))
  {
     TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  TST_ATP_Error = DX_VOS_FOpen(&TST_cache_file, "cache.image.bin" ,"rb");
  if ((TST_ATP_Error != DX_SUCCESS)||(TST_cache_file == DX_NULL))
  {
     TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }

  /*read the resident file size*/
  TST_ATP_Error = DX_VOS_FReadEx(TST_Resident_file,(DxUint8_t*)TST_resAdd,sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  size = *(DxUint32_t*)TST_resAdd;
  
  /*read the resident */
  TST_ATP_Error = DX_VOS_FReadEx(TST_Resident_file,(DxUint8_t*)TST_resAdd+sizeof(DxUint32_t),(size -1)*sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != (size -1)*sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  
  /*read the cache file size*/
  TST_ATP_Error = DX_VOS_FReadEx(TST_cache_file,(DxUint8_t*)TST_cacheAddr,sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  size = *(DxUint32_t*)TST_cacheAddr;
  
  /*read the cache */
  TST_ATP_Error = DX_VOS_FReadEx(TST_cache_file,(DxUint8_t*)TST_cacheAddr+sizeof(DxUint32_t),(size -1)*sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != (size -1)*sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  
  TST_End_function:
  DX_VOS_FClose(TST_Resident_file);
  DX_VOS_FClose(TST_cache_file);
  return TST_ATP_Error;
}

/********************************************************************************
 * Function Name:                                                           
 * 	MW_ATP_UTIL_CC_OSLoadExtCode 		
 * 
 * Inputs:
 * 	
 *
 * Outputs:
 *  DxUint32_t  TST_extCacheAddr - allocated ext cache  address
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function load the external(3rd party) cache. The implementation of this function 
 * is done for ARM integration board hardware and provided as an example and 
 * reference only. 
 * 
 ********************************************************************************/
DxError_t MW_ATP_UTIL_CC_LoadExtCode(DxUint32_t TST_extCacheAddr)
{
  /* reg val */
  DxUint32_t    readBytes;
  DxUint32_t    size;

  /* file descriptor */
  DxVosFile TST_extCache_file;

  /*---------------------
      CODE
  -------------------------*/
  TST_ATP_Error  = TST_PASS;

  TST_ATP_Error = DX_VOS_FOpen(&TST_extCache_file, "extapp.image.bin" ,"rb");
  if ((TST_ATP_Error != DX_SUCCESS)||(TST_extCache_file == DX_NULL))
  {
     TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }

  /*read the ext cache file size*/
  TST_ATP_Error = DX_VOS_FReadEx(TST_extCache_file,(DxUint8_t*)TST_extCacheAddr,sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  size = *(DxUint32_t*)TST_extCacheAddr;
  
  /*read the ext cache */
  TST_ATP_Error = DX_VOS_FReadEx(TST_extCache_file,(DxUint8_t*)TST_extCacheAddr+sizeof(DxUint32_t),(size -1)*sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != (size -1)*sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }

  TST_End_function:
  DX_VOS_FClose(TST_extCache_file);
  return TST_ATP_Error;
}



/************************ Public Functions *************************/
/********************************************************************************
 * Function Name:                                                           
 * 	MW_ATP_UTIL_CC_OSLoadCode 		
 * 
 * Inputs:
 * 	DxUint32_t  TST_resAdd - resident address
 *  DxUint32_t  TST_cacheAddr - cache address
 *
 * Outputs:
 * 	DxUint32_t  TST_resAdd_ptr - resident address
 *  DxUint32_t  TST_cacheAddr_ptr - cache address
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function load the resident and cache in the OS configuration. The implementation of this function 
 * is done for ARM integration board hardware and provided as an example and 
 * reference only. 
 * 
 ********************************************************************************/
DxError_t MW_ATP_UTIL_CC_OSLoadCode(DxUint32_t* TST_resAddr_ptr, DxUint32_t* TST_cacheAddr_ptr)
{
  /* reg val */
  DxUint32_t    readBytes;
  DxUint32_t    size;

  /* files descriptors */
  DxVosFile TST_Resident_file;
  DxVosFile TST_cache_file;
  
  DxUint8_t*    resident_ptr;
  DxUint8_t*    cache_ptr;
  DxUint32_t    resident_size;
  DxUint32_t    cache_size;

  /*---------------------
      CODE
  -------------------------*/
  TST_ATP_Error  = TST_PASS;
  
  resident_ptr = DX_NULL;
  cache_ptr = DX_NULL;
  

  TST_ATP_Error = DX_VOS_FOpen(&TST_Resident_file, "resident.image.bin" ,"rb");
  if ((TST_ATP_Error != DX_SUCCESS)||(TST_Resident_file == DX_NULL))
  {
     TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  TST_ATP_Error = DX_VOS_FOpen(&TST_cache_file, "cache.image.bin" ,"rb");
  if ((TST_ATP_Error != DX_SUCCESS)||(TST_cache_file == DX_NULL))
  {
     TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }

  /*read the resident file size*/
  TST_ATP_Error = DX_VOS_FReadEx(TST_Resident_file,(DxUint8_t*)&resident_size,sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  size = resident_size;
  
  /* allocate the resident buffer */
  resident_ptr = DX_VOS_MemMalloc(size * sizeof(DxUint32_t));
  if(!resident_ptr)
  {
    TST_ATP_Error = TST_FAIL;
    goto TST_End_function;
  }
  
  /* set the resident size */
  *((DxUint32_t*)resident_ptr) = resident_size;
  
  /*read the resident */
  TST_ATP_Error = DX_VOS_FReadEx(TST_Resident_file,(DxUint8_t*)resident_ptr + sizeof(DxUint32_t),(size -1)*sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != (size -1)*sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function_error;
  }
  
  /*read the cache file size*/
  TST_ATP_Error = DX_VOS_FReadEx(TST_cache_file,(DxUint8_t*)&cache_size,sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function_error;
  }
  size = cache_size;
  
  cache_ptr = DX_VOS_MemMalloc(size * sizeof(DxUint32_t));
  if(!cache_ptr)
  {
    TST_ATP_Error = TST_FAIL;
    goto TST_End_function_error;
  }
  
  /* set the resident size */
  *((DxUint32_t*)cache_ptr) = cache_size;
  
  /*read the cache */
  TST_ATP_Error = DX_VOS_FReadEx(TST_cache_file,(DxUint8_t*)cache_ptr+sizeof(DxUint32_t),(size -1)*sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != (size -1)*sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function_error;
  }
  
  goto TST_End_function;

TST_End_function_error:

  if(resident_ptr)
  {
    DX_VOS_MemFree(resident_ptr);
  }
  
  if(cache_ptr)
  {
    DX_VOS_MemFree(cache_ptr);
  }
  
TST_End_function:
  DX_VOS_FClose(TST_Resident_file);
  DX_VOS_FClose(TST_cache_file);
  
  *TST_resAddr_ptr = (DxUint32_t)resident_ptr;
  *TST_cacheAddr_ptr = (DxUint32_t)cache_ptr;
  
  return TST_ATP_Error;
}

/********************************************************************************
 * Function Name:                                                           
 * 	MW_ATP_UTIL_CC_OSLoadExtCode 		
 * 
 * Inputs:
 * 	
 *
 * Outputs:
 *  DxUint32_t*  TST_extCacheAddr - allocated ext cache  address
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function load the external(3rd party) cache. The implementation of this function 
 * is done for ARM integration board hardware and provided as an example and 
 * reference only. 
 * 
 ********************************************************************************/
DxError_t MW_ATP_UTIL_CC_OSLoadExtCode(DxUint32_t* TST_extCacheAddr_ptr)
{
  /* reg val */
  DxUint32_t    readBytes;
  DxUint32_t    size;
  DxUint32_t    extCacheSize;
  DxUint8_t*    extCache_ptr;
  
  /* file descriptor */
  DxVosFile TST_extCache_file;

  /*---------------------
      CODE
  -------------------------*/
  TST_ATP_Error  = TST_PASS;

  TST_ATP_Error = DX_VOS_FOpen(&TST_extCache_file, "extapp.image.bin" ,"rb");
  if ((TST_ATP_Error != DX_SUCCESS)||(TST_extCache_file == DX_NULL))
  {
     TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }

  /*read the ext cache file size*/
  TST_ATP_Error = DX_VOS_FReadEx(TST_extCache_file,(DxUint8_t*)&extCacheSize,sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  size = extCacheSize;
  
  /* allocate the resident buffer */
  extCache_ptr = DX_VOS_MemMalloc(size * sizeof(DxUint32_t));
  if(!extCache_ptr)
  {
    TST_ATP_Error = TST_FAIL;
    goto TST_End_function;
  }
  
  /* set the resident size */
  *((DxUint32_t*)extCache_ptr) = extCacheSize;
  
  /*read the ext cache */
  TST_ATP_Error = DX_VOS_FReadEx(TST_extCache_file,(DxUint8_t*)extCache_ptr + sizeof(DxUint32_t),(size -1) * sizeof(DxUint32_t),&readBytes);
  if ((TST_ATP_Error != DX_SUCCESS)||(readBytes != (size -1)*sizeof(DxUint32_t)))
  {
  	 TST_ATP_Error = TST_FAIL;
     goto TST_End_function;
  }
  
  *TST_extCacheAddr_ptr = (DxUint32_t)extCache_ptr;
  
TST_End_function:

  DX_VOS_FClose(TST_extCache_file);
  return TST_ATP_Error;
}



